<?php
require_once 'config.php';

// Set content type
header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(false, 'Method not allowed', null, 405);
}

// Get JSON input
$jsonInput = file_get_contents('php://input');
$data = json_decode($jsonInput, true);

if (!$data) {
    jsonResponse(false, 'Invalid JSON data', null, 400);
}

// Get session ID
$sessionId = sanitizeInput($data['session_id'] ?? '');

if (empty($sessionId)) {
    jsonResponse(false, 'Session ID required', null, 400);
}

// Validate session
$session = validateSession($sessionId);

if (!$session) {
    jsonResponse(false, 'Invalid or expired session', null, 401);
}

jsonResponse(true, 'Session valid', [
    'username' => $session['admin_id'],
    'expires_at' => $session['expires_at']
]);
?>